<?php
// Copyright (c) 2013 Vincent SENE
// http://www.vincent-sene.com/viniviewer/
// Licence: http://www.opensource.org/licenses/zlib-license.php

	
	//intgration du fichier d'initialisation
	include_once('init_data.php');
	
	//set session language = admin language
	$_SESSION["language"] = $GLOBALS['PARAMETERS']['language'];
	
	//parcours le repertoires images
	function parcours_img() {
		
		//on rcupre les variables globales que l'on va utiliser
		global $folder_images, $images, $folders;
		
		//rcupre le nom du rpertoire en fonction de l'index
		$folder = $folder_images;
		
		//if folder images doesnt exist, we create it
		if(!file_exists($folder)){
			@mkdir($folder) or die($translastion["err_creat_img_folder"]);
			
			$index_file = "$folder/index.html";
			if(!file_exists($index_file)){
				file_put_contents($index_file, '');
			}
		}
		
		//ouverture du repertoire contenant les images
		$dir = opendir($folder) or die($GLOBALS['TRANSLATION']["err_open_img_folder"]); 

		//on liste les images et repertoires du dossier courant
		$i = 0;
		while(false !== ($element = readdir($dir))) {
			//creation of object for each images of folder. $i used as counter
			create_object($element, $folder);
		}
		closedir($dir);
	}
	
	//create a object for an image and read all data of it
	function create_object($file, $folder){
		global $images, $folders, $filtre_format_img;
		
		//incrementation of index
		$i = count($images);
		$j = count($folders);
		
		if (!is_dir($folder.'/'.$file)) {
			//on test l'extension du fichier en fonction de $filtre_format_img
			foreach($filtre_format_img as $ext){
				//on force les minuscules sur l'extension pour la comparaison
				$ext_file = strtolower(pathinfo($file, PATHINFO_EXTENSION));
				if ($ext == $ext_file){
					$path = "$folder/$file";
					
					//on enregistre les dimensions
					$fileinfo = getimagesize($path);
				
					//cration d'une instance de la class Images
					$images[$i] = new ObjImage();
					$images[$i]->filename =  $file;
					$images[$i]->folder = $folder;
					$images[$i]->text_in("");
					$images[$i]->date_img = filemtime($folder."/".$file);
					$images[$i]->width = $fileinfo[0];
					$images[$i]->height = $fileinfo[1];
					$images[$i]->position = $i;
					$images[$i]->hide = false;
					
					//extraction of EXIF data, only for jpeg file
					$type_mime = $fileinfo['mime'];
					$type      = str_replace('image/', '', $type_mime);
					if($type == "jpeg" && function_exists(exif_read_data)){
						$exif = exif_read_data($path);
						$images[$i]->exif['Make'] = exif_data($exif, 'Make');
						$images[$i]->exif['Model'] = exif_data($exif, 'Model');
						$images[$i]->exif['DateTimeOriginal'] = exif_data($exif, 'DateTimeOriginal');
						$images[$i]->exif['ExposureTime'] = exif_data($exif, 'ExposureTime');
						$images[$i]->exif['ISOSpeedRatings'] = exif_data($exif, 'ISOSpeedRatings');
						$images[$i]->exif['FocalLength'] = exif_data($exif, 'FocalLength');
						$images[$i]->exif['FocalLengthIn35mmFilm'] = exif_data($exif, 'FocalLengthIn35mmFilm');
						$images[$i]->exif['FNumber'] = exif_data($exif, 'FNumber');
						$images[$i]->exif['LensModel'] = exif_data($exif, 'UndefinedTag:0xA434');
						$images[$i]->exif['Software'] = exif_data($exif, 'Software');
					}
					break;
				}
			}
		}
		//list folders
		else{
			if($file != "." && $file != ".."){
				$folders[$j] = new ObjFolder();
				$folders[$j]->foldername =  $file;
				$folders[$j]->folderpath = $folder.'/'.$file;
				$folders[$i]->hide = false;
			}
		}				
	}
	
	//extraction et mise en forme des infos exif
	function exif_data($array, $parameter){
		if ($array[$parameter]){
			
			$data = $array[$parameter];
			if($parameter == "ExposureTime"){
				$data .= "s";
			}
			elseif($parameter == "FocalLength"){
				list($x,$y) = explode('/', $data);
				$data = round($x/$y,0)."mm";
			}
			elseif($parameter == "FocalLengthIn35mmFilm"){
				$data .= "mm";
			}
			elseif($parameter == "FNumber"){
				list($x,$y) = explode('/', $data);
				$data = "f/".round($x/$y,0);
			}
			elseif($parameter == "Model" || $parameter == "Software"){
				$data = trim($data);
			}
			return $data;
		}
	}	
	
	//update json file:
	function update_json($sort_option){
		
		//get globales variables
		global $images, $json_file;
	
		//sort image by attribut: filename, date or position
		if(ISSET($sort_option)){
			//define sort direction : up or down
			$opt = $sort_option[0];
			if($opt == "u"){
				$GLOBALS['sort_dir'] = 1;
			}
			else{
				$GLOBALS['sort_dir'] = -1;
			}
			
			$srt = substr($sort_option, 1); 

			if($srt == "file_name"){
				usort($images, "compare_filename");
			}
			elseif($srt == "file_date"){
				usort($images, "compare_date");
			}
			elseif($srt == "origin_date"){
				usort($images, "compare_EXIFdate");
			}
			elseif($srt == "custom_sort"){
				usort($images, "compare_pos");
			}
		}

		//on encode en JSON
		$text_for_gallery = json_encode($images);
			
		//on enregistre les infos dans le fichier js
		file_put_contents($json_file, $text_for_gallery);
		
		//mise  jour du fichier config avec la version du code json utilis
		$CONFIG["current_json_file_version"] = $json_file_version;
		update_config();
		
		//update json folder file
		update_json_folder();
	}
	
	//update json file:
	function update_json_folder(){
		
		//get globales variables
		global $folders, $json_folder_file;
	
		//on encode en JSON
		$text_for_folder = json_encode($folders);
			
		//on enregistre les infos dans le fichier js
		file_put_contents($json_folder_file, $text_for_folder);
	}
	
	//fonction gnrant les images miniatures
	function generate_thumbnails() {
		//on rcupre les variables globales
		global $images, $folder_images, $folder_thumbnails, $thb_size;
		
		//creation of thumbnails folder, if needed 
		if(!file_exists($folder_thumbnails)){
			@mkdir($folder_thumbnails) or die($GLOBALS['TRANSLATION']["err_creat_thb_folder"]);
		}
		//creation of index file, if needed 
		$index_file = "$folder_thumbnails/index.html";
		if(!file_exists($index_file)){
			file_put_contents($index_file, '');
		}	
		
		read_json();
		foreach($images as $key => $obj_img){
			//on rcupre le chemin de l'image
			$img_url = $obj_img->path();
			$thb_url = "$folder_thumbnails/".$obj_img->filename;
			
			//if thb no exist
			if (!file_exists($thb_url)){
				//thb image creation
				//arguments = source, cible, taille, expand, format carr
				imagethumb ($img_url, $thb_url, $thb_size, false, true);
			}
		}
	}
	
	/* 	FONCTION IMAGETHUMB()
	http://code.seebz.net/p/imagethumb/
	
	Envoie la miniature d'une image vers un navigateur ou un fichier.

	imagethumb() gnre une copie de l'image image_src aux dimensions maximales max_size et l'envoie vers un navigateur ou le fichier image_dest.
	imagethumb() utilise la bibliothque GD et retournera FALSE si celle-ci n'est pas disponible
	imagethumb() fonctionne correctement avec les images de type Jpeg, Png et Gif. Dans le cas d'un Gif anim, seule la premire frame sera utilis.
	imagethumb() gre la transparence.
	
	Syntaxe:
	bool imagethumb ( string $image_src [, string $image_dest = null [, int $max_size = 100 [, bool $expand = false [, bool $square = false ]]]] )
	
	Arguments:
    image_src - Chemin vers l'image source.
    image_dest - Le chemin de destination. S'il n'est pas dfini ou s'il vaut NULL, le flux brut de l'image sera affich directement.
    Pour viter de fournir cet argument afin de fournir l'argument max_size, utilisez une valeur NULL.
    max_size - La taille maximale (largeur ou hauteur) de l'image de destination. Ce paramtre optionnel a pour valeur par dfaut 100.
    expand - Si ce paramtre vaut TRUE, imagethumb() pourra ventuellement agrandir l'image pour atteindre la taille max_size dans le cas ou la taille de image_src est plus petite que max_size
    square - Si ce paramtre vaut TRUE, la miniature gnre sera carre.
	*/
	function imagethumb( $image_src , $image_dest = NULL , $max_size = 100, $expand = FALSE, $square = FALSE ){
		if(!file_exists($image_src)) return FALSE;

		// Rcupre les infos de l'image
		$fileinfo = getimagesize($image_src);
		if(!$fileinfo) return FALSE;

		$width     = $fileinfo[0];
		$height    = $fileinfo[1];
		$type_mime = $fileinfo['mime'];
		$type      = str_replace('image/', '', $type_mime);

		if( !$expand && max($width, $height)<=$max_size && (!$square || ($square && $width==$height))){
			// L'image est plus petite que max_size
			if($image_dest){
				return copy($image_src, $image_dest);
			}
		}

		// Calcule les nouvelles dimensions
		$ratio = $width / $height;

		if( $square ){
			$new_width = $new_height = $max_size;

			if( $ratio > 1 ){
				// Paysage
				$src_y = 0;
				$src_x = round( ($width - $height) / 2 );

				$src_w = $src_h = $height;
			}
			else{
				// Portrait
				$src_x = 0;
				$src_y = round( ($height - $width) / 2 );

				$src_w = $src_h = $width;
			}
		}
		else{
			$src_x = $src_y = 0;
			$src_w = $width;
			$src_h = $height;

			if ( $ratio > 1 ){
				// Paysage
				$new_width  = $max_size;
				$new_height = round( $max_size / $ratio );
			}
			else{
				// Portrait
				$new_height = $max_size;
				$new_width  = round( $max_size * $ratio );
			}
		}

		// Ouvre l'image originale
		$func = 'imagecreatefrom' . $type;
		if(!function_exists($func)) return FALSE;

		$image_src = $func($image_src);
		$new_image = imagecreatetruecolor($new_width,$new_height);

		// Gestion de la transparence pour les png
		if( $type=='png'){
			imagealphablending($new_image,false);
			if( function_exists('imagesavealpha')){
				imagesavealpha($new_image,true);
			}
		}
		// Gestion de la transparence pour les gif
		elseif( $type=='gif' && imagecolortransparent($image_src)>=0 ){
			$transparent_index = imagecolortransparent($image_src);
			$transparent_color = imagecolorsforindex($image_src, $transparent_index);
			$transparent_index = imagecolorallocate($new_image, $transparent_color['red'], $transparent_color['green'], $transparent_color['blue']);
			imagefill($new_image, 0, 0, $transparent_index);
			imagecolortransparent($new_image, $transparent_index);
		}

		// Redimensionnement de l'image
		imagecopyresampled(
			$new_image, $image_src,
			0, 0, $src_x, $src_y,
			$new_width, $new_height, $src_w, $src_h
		);

		//quality of picture
		if($type=='png'){$qlty = 0;}
		elseif($type=='jpeg'){$qlty = 95;}
		elseif($type=='png'){$qlty = "";}
		
		// Enregistrement de l'image
		$func = 'image'. $type;
		if($image_dest){
			$func($new_image, $image_dest, $qlty);
		}

		// Libration de la mmoire
		imagedestroy($new_image); 
		return TRUE;
	}
	
	//fonction pour dtruire la session
	function destroy_session(){
		unset($_SESSION["user_logged"]);
	}
	
	//generate the javascript to include into template page
	function generate_javascript(){
		global $images;
	
		$java_code = "var tab_filename = new Array();\nvar com = new Array();\n";
		
		foreach($images as $key => $obj_img){
			$filename = $obj_img->filename;
			$java_code .= " tab_filename[$key] = '$filename';";
			$comment = $obj_img->text_out('java');
			$java_code .= " com[$key] = $comment;";
		}
		
		//files sizes data
		$java_code .= "\nvar maxUploadSizeO = '".max_upload_size()."';";
		$java_code .= "\nvar maxUploadSize = '".max_upload_size(1)."';";
		
		return $java_code;
	}
	
	//generate table lines (<tr><td>) to display thumbail data 
	function list_thumbnails() {
		
		//on rcupre les variables globales
		global $images, $folder_images, $folder_thumbnails, $thb_size, $theme_path;
	
		$code = "";
		foreach($images as $key => $obj_img){
			$img_url = $obj_img->path();
			$img = $obj_img->filename;
			$hide = $obj_img->hide;
			$comment = $obj_img->text_out();
			$date = $obj_img->date_img_formated();
			$exif = $obj_img->show_EXIF();
			$title = $img;
		
			//on rcupre le chemin de l'image
			$thb_url = "$folder_thumbnails/".$img;
			
			if($hide == true){
				$bt_hide = "button_hide_on.png";
				$thb_class = "thb_hide";
				$hide_txt = $GLOBALS['TRANSLATION']["unhide_img"];
			}
			else{
				$bt_hide = "button_hide.png";
				$thb_class = "thb";
				$hide_txt = $GLOBALS['TRANSLATION']["hide_img"];
			}
			
			//test if files are present
			if(!file_exists($img_url)){
				$img_url = "$theme_path/images/thb_lost.png";
			}
			if(!file_exists($thb_url)){
				$thb_url = "$theme_path/images/thb_lost.png";
				$title = $GLOBALS['TRANSLATION']["thb_not_found"];
			}
			
			$size = $thb_size."px"; 
			
			$code .= "<tr>
				<td><input type='checkbox' id='thb_$key' name='thb[$key]' /></td>
				<td class='td_option'>
					<img src='themes/default/images/$bt_hide' onclick='confirm_msg(\"hide\",$key)' title='$hide_txt' alt='H' />
					<br />
					<img src='themes/default/images/button_refresh.png' onclick='confirm_msg(\"redo_thb\",$key)' title='".$GLOBALS['TRANSLATION']["redo_thb"]."' alt='R' />
					<br />
					<img src='themes/default/images/button_cancel.png' onclick='confirm_msg(\"sup\",$key)' title='".$GLOBALS['TRANSLATION']["suppress"]."' alt='X' />
				</td>
				<td>$key</td>
				<td>
					<a href='$img_url' title='$img'>
						<img src='$thb_url' title='$title' alt='thb_$key' class='$thb_class' />
					</a>
				</td>
				<td>$img</td>
				<td>$date</td>
				<td>
					<textarea name='com[$key]' rows='1' cols='25' max_length='250' id='com_txt_$key' onkeyup='data_changed($key, this.value);' onchange='data_changed($key, this.value);' >$comment</textarea>
					<div id='btn_com_$key' class='btn_com'>
					<img src='themes/default/images/button_cancel.png' title='".$GLOBALS['TRANSLATION']["cancel"]."' onclick='cancel_com($key)' />
					<img src='themes/default/images/button_ok.png' title='".$GLOBALS['TRANSLATION']["validate"]."' onclick='valid_com($key)' />
					</div>
				</td>
				<td class='td_left'>$exif</td>
			</tr>";
		}
		return $code;
	}
	
	// compare two objects by filename attribut
	function compare_filename($a, $b) {
		return ($GLOBALS['sort_dir'] * strcasecmp($a->filename, $b->filename));
	}

	// compare two objects by date_img attribut (filename date)
	function compare_date($a, $b) {
		return ($GLOBALS['sort_dir'] * ($a->date_img - $b->date_img));
	}
	
	// compare two objects by original date attribut (from exif)
	function compare_EXIFdate($a, $b) {
		//use EXIF date if available (YYY-mm-dd...), otherwise file date (timestamp UNIX)
		if(isset($a->exif['DateTimeOriginal'])){
			$da = strtotime($a->exif['DateTimeOriginal']);
		}
		else
		{$da = $a->date_img;}
		
		if(isset($b->exif['DateTimeOriginal'])){
			$db = strtotime($b->exif['DateTimeOriginal']);
		}
		else
		{$db = $b->date_img;}
	  
		return ($GLOBALS['sort_dir'] * ($da - $db));
	}
	
	// compare two objects by position attribut
	function compare_pos($a, $b) {
		return ($GLOBALS['sort_dir'] *($a->pos - $b->pos));
	}
	
	//get the max size allowed for upload
	function max_upload_size($native = null){
		$val = trim(ini_get('post_max_size'));
		
		//use to display the size in octet (instead of native format. i.e.: 8Mo)
		if ($native == null){
			$last = strtolower($val[strlen($val)-1]);
			switch($last) { case 'g': $val *= 1024; case 'm': $val *= 1024; case 'k': $val *= 1024;	}
		}
		return $val; 
	}
	
	//generate code for diapo delay option
	function code_opt_diapo(){
		
		$t = array(1, 2, 3, 4, 5, 10, 15, 20);
		$code = "";
			
		foreach($t as $key => $value){
			$slt = "";
			$mls = intval($value) * 1000;
			
			if ($mls == $GLOBALS['PARAMETERS']['delay_diapo']){$slt = "selected";}
			$code .= "<option value='$mls' $slt>$value sec</option>";
		}
		return $code;
	}
	
	//generate code for exif display option
	function code_opt_exif(){
		$opt0 = "";
		$opt1 = "";
		//get user parameter
		$opt = intval($GLOBALS['PARAMETERS']['allow_exif']);
		
		//pre select following user parameter
		if ($opt == 1){$opt1 = "selected";}
		if ($opt == 0){$opt0 = "selected";}
		
		$code = "<option value='1' $opt1>".$GLOBALS['TRANSLATION']['yes']."</option>";
		$code .= "<option value='0' $opt0>".$GLOBALS['TRANSLATION']['no']."</option>";
		
		return $code;
	}
	
	//generate code for sort option
	function code_opt_sort(){
		$t = array("file_date", "origin_date", "file_name");
		$d['u'] = "&uarr;";
		$d['d'] = "&darr;";
		$code = "";
			
		foreach($t as $key => $sort){
			
			//for up / down option
			foreach($d as $dir => $arr){
				$slc = "";
				$opt_v = $dir.$sort;
				if ($opt_v == $GLOBALS['PARAMETERS']['sort_option']){$slc = "selected";}
				$code .= "<option value='$opt_v' $slc>".$GLOBALS['TRANSLATION'][$sort]." $arr</option>";
			}
		}
		return $code;
	}

	//generate code for theme option
	function code_opt_theme(){
		$themes = array("default", "flat");
		$code = "";
			
		foreach($themes as $key => $value){
			$slt = "";
			
			if ($value == $GLOBALS['PARAMETERS']['theme']){$slt = "selected";}
			$code .= "<option value='$value' $slt>$value</option>";
		}
		return $code;
	}
	
	
	//utilisateur non identifi
	if(!ISSET($_SESSION["user_logged"])) {
		header('Location: login.php');
	}
	//si l'utilisateur est identifi.
	else{
		//--------------------------
		//gnration du fichier json
		//--------------------------
		if(ISSET($_SESSION["install_js"])){
			//on liste les images du dossier images
			parcours_img();
			//on enregistre les infos dans le fichier json
			update_json($GLOBALS['PARAMETERS']['sort_option']);
			$nb_img = count($images);
			
			//js est cr, on detruit le traceur
			unset($_SESSION["install_js"]);
			
			//on rinjecte les valeurs de quelques variables
			$VAR_TP = array(
				"{folder_images}",
				"{nb_img}",
				);
			$VAR_CODE = array(
				$folder_images, 
				$nb_img, 
				);

			$msg = $GLOBALS['TRANSLATION']["js_file_done"];
			//insertion des messages dans la page  afficher
			$msg = str_replace($VAR_TP, $VAR_CODE, $msg);
	
			$_SESSION["message_title"] = $GLOBALS['TRANSLATION']["install_viniviewer"];
			$_SESSION["message"] = $msg;
		}

		//--------------------------
		//gestion de la cration des miniatures
		//--------------------------
		if (ISSET($_SESSION["install_thb"])){
			//thb creation requested from message page
			if(ISSET($_GET['dothb'])){
				generate_thumbnails();
				unset($_SESSION["install_thb"]);
				
				//on met  jour le fichier config
				$CONFIG["thb_rdy"] = true;
				update_config();

				//on recharge la page pour eviter les actualisation avec F5
				header('Location: admin.php');
			}
			elseif(!ISSET($_GET['cancel'])){
				//la gnration tant longue, on demande confirmation
				//de plus, dans le cadre d'une premire install, on cumule le message avec le msg prcdent
				if(!ISSET($_SESSION["message"])){
					$_SESSION["message"] = "";
					$_SESSION["message_title"] = $GLOBALS['TRANSLATION']["generate_thb"];
				}
				else{
					$_SESSION["message"] .= "<br />";
				}
				
				//on revoi vers une page de message
				$_SESSION["message"] .= $GLOBALS['TRANSLATION']["thb_2_confirm"];
				read_json();
				
				//nb of thb already existing in folder
				$nb_thb = count(scandir($folder_thumbnails))-3;	//remove 3 for . & .. directories, and index.htm file
				$nb_img = count($images);
				$est_thb_time = round(($nb_img-$nb_thb)/6);	//6 is a rough estimation following my experience. depend of server capapbility
				//on rinjecte les valeurs de quelques variables
				$_SESSION["message"] = str_replace("{est_thb_time}", $est_thb_time, $_SESSION["message"]);
				$_SESSION["message"] = str_replace("{thb_to_gen}", $nb_img-$nb_thb, $_SESSION["message"]);
				
				$_SESSION["message_btn"] = "ok/cancel";
				$_SESSION["message_parameter"] = "dothb";
			}
		}
	
		//--------------------------
		//GET MANAGEMENT
		//--------------------------
		if(!empty($_GET)){
			//logout request
			if(ISSET($_GET['logout'])){
				destroy_session();

				header('Location: login.php');
			}
			//language change request
			elseif(ISSET($_GET['L'])){
				$CONFIG["language"] = $_GET['L'];
				
				//save config file
				update_config();
				header('Location: admin.php');
			}
			//refresh img list request
			elseif(ISSET($_GET['refresh'])){
				$_SESSION["install_js"] = true;
				$_SESSION["install_thb"] = true;
				header('Location: admin.php');
			}
			//thb creation is cancelled
			elseif(ISSET($_GET['cancel'])){
				unset($_SESSION["install_thb"]);
				$CONFIG["thb_rdy"] = true;
				update_config();

				header('Location: admin.php');
			}
			//drag and drop management (AJAX)
			elseif(!empty($_FILES)){
				header('content-type: application/json');
				//folder to upload images
				$upload_folder = "./{$folder_images}/";
				
				//read json to list all images
				read_json();				
				
				foreach ($_FILES as $file) {
					$raw_name = $file['name'];
					//clean file name
					$name=str_replace(array("..", "/", "\\", "\n", "\r", "\0"), "_", $file['name']);
					
					if(!in_array($name, array("", ".", ".."))){
						//when file is save into the folder
						if(move_uploaded_file($file['tmp_name'], $upload_folder.$name)){
							
							//if filename already exist, we remove previous data
							foreach($images as $key=>$obj){
								if($obj->filename == $name){
									unset($images[$key]);
									break;
								}
							}
							
							//create object for new image added
							create_object($name, $folder_images);
							
							//create thumbnails for new image
							$i = count($images)-1;

							$img_url = $images[$i]->path();
							$thb_url = "$folder_thumbnails/".$images[$i]->filename;
							
							//generate thb image
							//arguments = source, cible, taille, ajustement, format carr
							imagethumb ($img_url, $thb_url, $thb_size, false, true);
							
							//return the raw name file
							$return["raw_name"][] = $raw_name;
						
							$i++;
						}
					}
				}
				//add data in images objects list
				update_json($GLOBALS['PARAMETERS']['sort_option']);
				
				//generate table code for admin panel display
				$return["line_code"] = list_thumbnails();

				echo json_encode($return);
			}else{
				echo json_encode(array("error"));
			}
			exit;
		}
		
		//----------------
		//POST management
		//----------------
		if(ISSET($_POST)){
		
			//viewer options changed
			if(ISSET($_POST['options'])){
		
				//direct update if sort option is changed
				if($CONFIG['sort_option'] != $_POST['sort_option']){
					read_json();
					update_json($_POST['sort_option']);
				}
				
				$CONFIG['gal_name'] = $_POST['gal_name'];
				$CONFIG['delay_diapo'] = $_POST['delay_diapo'];
				$CONFIG['allow_exif'] = $_POST['allow_exif'];
				$CONFIG['sort_option'] = $_POST['sort_option'];
				$CONFIG['theme'] = $_POST['theme'];
				
				//save config option in config file
				update_config();
				
				//redirection, to avoid refresh with F5
				header('Location: admin.php');
			}
			
		
			//mise  jour des commentaires
			if(ISSET($_POST['com_to_save']) && $_POST['com_to_save'] != ""){

				//get table $images which list all image objects
				read_json();
				
				$id = $_POST['com_to_save'];
				//get all comments and update them
				foreach($_POST['com'] as $key => $com){
					
					//if all com updated must be saved
					if($id == "all"){
						$images[$key]->text_in($com);
					}
					//update only a specific img
					elseif($id == $key){
						$images[$key]->text_in($com);
						break;
					}
				}
				//save modification in JSon file
				update_json();
				
				//redirection, to avoid refresh with F5
				header('Location: admin.php');
			}
			
			//suppress one or several pictures
			if(ISSET($_POST['action_to_manage']) && $_POST['action_to_manage'] != ""){
				
				$action = $_POST['action_to_manage'];
				$id = $_POST['thb_to_manage'];

				//several images to manage
				if($id == "several"){
					$thb_id = $_POST['thb'];
				}
				//one image to manage
				else{
					$thb_id[$id] = "on";
				}
				
				//get table $images which list all image objects
				read_json();
				
				if($action == "hide"){
					foreach($thb_id as $id =>$value){
						//if key exist in array
						if(array_key_exists($id, $images)){
							if($images[$id]->hide == true){	
								$images[$id]->hide = false;
							}
							else{
								$images[$id]->hide = true;
							}
						}
					}
					//save modification in JSon file
					update_json();					
				}
				//remove image
				elseif($action == "sup"){
					foreach($thb_id as $id =>$value){
						//if key exist in array
						if(array_key_exists($id, $images)){
							//destroy image 
							unlink($images[$id]->path());
							//destroy thb 
							$thb_link = "$folder_thumbnails/".$images[$id]->filename;
							unlink($thb_link);
								
							//remove the object from collection
							unset($images[$id]);
						}
					}
					//save modification in JSon file
					update_json($GLOBALS['PARAMETERS']['sort_option']);
				}
				elseif($action == "redo_thb"){
					global $thb_size;
					foreach($thb_id as $id =>$value){
						//if key exist in array
						if(array_key_exists($id, $images)){
							//set path of thb to redo
							$img_url = $images[$id]->path();
							$thb_url = "$folder_thumbnails/".$images[$id]->filename;
							//redo thb
							//arguments = source, target, size, adjustement, square shape
							imagethumb ($img_url, $thb_url, $thb_size, false, true);
						}
					}
				}
				
				//redirection, to avoid refresh with F5
				header('Location: admin.php');
			}
		}
		
		//----------------------------------
		//si message  afficher, on redirige vers la page message
		//----------------------------------
		if (ISSET($_SESSION["message"])){
			header('Location: message.php');
		}
		
		
		//---------------------------
		//affichage de la page d'administration
		//---------------------------
		//on rcupre le template de la page
		$admin_page = file_get_contents('themes/default/templates/admin.htm');
		
		//on lit le fichier JSON de la galerie
		read_json();

		//on gnre le tableau reprsentant les images
		$table_img_list = list_thumbnails();

		//generate code for options
		$gal_name = $GLOBALS['PARAMETERS']['gal_name'];
		$code_opt_delay = code_opt_diapo();
		$code_opt_exif = code_opt_exif();
		$code_opt_sort = code_opt_sort();
		$code_opt_theme = code_opt_theme();
		$country_code = list_lang();
		$nb_img = count($images);
		
		//generate javascript to include into page
		$java_code = generate_javascript();
		
		//variables to add in the translation
		$COMP = array(
			"{gal_name}" => $gal_name,
			"{nb_img}" => $nb_img,
			"{folder_img}" => $folder_images,
			"{folder_thb}" => $folder_thumbnails,
			"{table_img_list}" => $table_img_list,
			"{code_opt_delay}" => $code_opt_delay,
			"{code_opt_exif}" => $code_opt_exif,
			"{code_opt_sort}" => $code_opt_sort,
			"{code_opt_theme}" => $code_opt_theme,
			"{java_code}" => $java_code,
			"{country_code}" => $country_code
		);
		echo translate($admin_page, $COMP);
	}
?>